//
//  MPAbstractOverlayWindow.h
//  Memphis
//
//  Created by iMac on 05.11.13.
//  Copyright (c) 2013 MacPhun LLC. All rights reserved.
//

#import "MPTopBarLessWindow.h"

@interface MPAbstractOverlayWindow : MPTopBarLessWindow

typedef NS_ENUM(NSUInteger, MPOverlayPositionType) {
    MPOverlayPositionTypeWindowCenter,
    MPOverlayPositionTypeScreenCenter,
};

@property (nonatomic, assign) IBInspectable BOOL needsAnimation;

+ (instancetype)overlayWindowFromXib;

+ (void)showInWindow:(NSWindow *)window;
+ (void)showInWindow:(NSWindow *)window completion:(void(^)())completion;
+ (void)showInWindow:(NSWindow *)window positionType:(MPOverlayPositionType)positionType completion:(void(^)())completion;
+ (void)showInWindow:(NSWindow *)window positionType:(MPOverlayPositionType)positionType completion:(void (^)())completion windowModalResponse:(NSInteger *)oResponse;

- (void)showInWindow:(NSWindow *)window;
- (void)showInWindow:(NSWindow *)window completion:(void(^)())completion;
- (void)showInWindow:(NSWindow *)window positionType:(MPOverlayPositionType)positionType completion:(void(^)())completion;
- (void)showInWindow:(NSWindow *)window positionType:(MPOverlayPositionType)positionType completion:(void (^)())completion windowModalResponse:(NSInteger *)oResponse;

- (IBAction)close:(id)sender;

@end
